// XISLSwitchDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "XISLSwitchDlg.h"
#include "XISLVarDlg.h"
#include "IBFlowView.h"
#include "XISLSwitchTag.h"
#include "XISLCaseTag.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CXISLSwitchDlg _CAO


CXISLSwitchDlg::CXISLSwitchDlg(CXISLSwitchTag *pSwitchTag,CXISLTag *pCurrentTag,CWnd* pParent /*=NULL*/)
	: CDialog(CXISLSwitchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXISLSwitchDlg)
	m_strExpr = _T("");
	m_strCase = _T("");
	m_bOther = FALSE;
	//}}AFX_DATA_INIT
	m_pSwitchTag = pSwitchTag;
	m_pCurrentTag = pCurrentTag;
}


void CXISLSwitchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXISLSwitchDlg)
	DDX_Control(pDX, IDC_LIST_CASE, m_lbCase);
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Text(pDX, IDC_EDIT_EXPR, m_strExpr);
	DDX_Text(pDX, IDC_EDIT_CASE, m_strCase);
	DDX_Check(pDX, IDC_CHECK_OTHER, m_bOther);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXISLSwitchDlg, CDialog)
	//{{AFX_MSG_MAP(CXISLSwitchDlg)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	ON_WM_CTLCOLOR()
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_CASE, OnEndlabeleditListCase)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXISLSwitchDlg bZ[W nh

BOOL CXISLSwitchDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_lbCase.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbCase.GetClientRect(&rect);
	column.cx = (rect.right-rect.left)-25;
	column.pszText = "l";
	m_lbCase.InsertColumn(0,&column);

	column.cx = 25;
	column.pszText = "No.";
	m_lbCase.InsertColumn(1,&column);

	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	m_lbVar.GetClientRect(&rect);
	column.cx = 50;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-50;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
	CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
	nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
	CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
	nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
	if(!pRTag->IsAppRoot() && g_pAppRootTag)
		g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	
	m_brEdit.CreateSolidBrush(RGB(255,255,255));

	char chrTemp[10];
	LVITEMA item;
	item.mask = LVIF_TEXT;
	int i=0;
	POSITION pos = m_pSwitchTag->m_CaseList.GetHeadPosition();
	while(pos)
	{
		CXISLCaseTag *pCTag = (CXISLCaseTag*)m_pSwitchTag->m_CaseList.GetNext(pos);
		if(pCTag->m_nTagType == ID_TAG_OTHER)
			break;
		CString strValue = pCTag->GetValue();
		item.iItem = i;
		item.iSubItem = 0;
		item.pszText = strValue.GetBuffer(strValue.GetLength());
		m_lbCase.InsertItem(&item);
		strValue.ReleaseBuffer();
	
		item.iSubItem = 1;
		item.pszText = itoa(i,chrTemp,10);
		m_lbCase.SetItem(&item);
		i++;
	}
	
	m_strExpr = m_pSwitchTag->GetExpr();
	UpdateData(FALSE);
	//other^O폜̂IBFlowViewłĂ
	if(m_pSwitchTag->HasOtherTag())
		GetDlgItem(IDC_CHECK_OTHER)->EnableWindow(FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CXISLSwitchDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		CXISLVar *pVar = (CXISLVar*)item.lParam;

		pVar->GetVarNameEx(m_strExpr);

		UpdateData(FALSE);
	}
	*pResult = 0;
}

BOOL CXISLSwitchDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		CWnd *pWnd = GetFocus();
		char chrTemp[10];
        switch( pMsg->wParam )
        {
        case VK_RETURN:   // Enter
			if(pWnd->GetDlgCtrlID() == IDC_EDIT_CASE)
			{
				UpdateData();
				LVFINDINFOA findinfo;
				findinfo.flags = LVFI_STRING;
				findinfo.psz = m_strCase.GetBuffer(m_strCase.GetLength());
				if(m_lbCase.FindItem(&findinfo) == -1)
				{
					m_strCase.ReleaseBuffer();
					int nCount = m_lbCase.GetItemCount();
					LVITEMA item;
					item.mask = LVIF_TEXT;
					item.iItem = nCount;
					item.iSubItem = 0;
					item.pszText = m_strCase.GetBuffer(m_strCase.GetLength());
					m_lbCase.InsertItem(&item);

					item.mask = LVIF_TEXT;
					item.iSubItem = 1;
					item.pszText = itoa(nCount,chrTemp,10);
					m_lbCase.SetItem(&item);
				}
				m_strCase.ReleaseBuffer();
				m_strCase.Empty();
				UpdateData(FALSE);
			}
			return TRUE;
//		case VK_DELETE:
//			break;
        default:
			break;
        }
	}	
	return CDialog::PreTranslateMessage(pMsg);
}

void CXISLSwitchDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	if(!m_pSwitchTag->SetAttribute(m_strExpr))
		return;

	int nOldCaseCount = m_pSwitchTag->m_CaseList.GetCount();
	if(m_pSwitchTag->HasOtherTag())
		nOldCaseCount--;
	else
	{
		if(m_bOther)
		{
			CXISLCaseTag *pOtherTag = new CXISLCaseTag(ID_TAG_OTHER);
			m_pSwitchTag->InsertCase(pOtherTag);
		}
	}

	int nNewCaseCount = m_lbCase.GetItemCount();
	int nIndex;
	//Ƃ肠ɂcase^OvaluelXV
	for(nIndex=0;nIndex<nNewCaseCount;nIndex++)
	{
		if(nIndex < nOldCaseCount)
		{
			POSITION pos = m_pSwitchTag->m_CaseList.FindIndex(nIndex);
			CXISLCaseTag *pCaseTag = (CXISLCaseTag*)m_pSwitchTag->m_CaseList.GetAt(pos);

			pCaseTag->SetValue(m_lbCase.GetItemText(nIndex,0));
		}
		else
		{
			CXISLCaseTag *pCTag = new CXISLCaseTag(ID_TAG_CASE);
			pCTag->SetValue(m_lbCase.GetItemText(nIndex,0));
			m_pSwitchTag->InsertCase(pCTag);
		}
	}

	CDialog::OnOK();
}

void CXISLSwitchDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	CDialog::OnCancel();
}

HBRUSH CXISLSwitchDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	switch(nCtlColor)
	{
	case CTLCOLOR_STATIC:
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_CASE)
		{
			pDC->SetBkMode(TRANSPARENT);	// wi
			pDC->SetTextColor(RGB(0,0,0));	// eLXgFݒ
			return (HBRUSH) m_brEdit;		// _~[uV
		}
	default:
		break;
	}	
	// TODO: ftHg̃uV]݂̂̂łȂꍇɂ́AႤuVԂĂ
	return hbr;
}

void CXISLSwitchDlg::OnEndlabeleditListCase(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ

	*pResult = TRUE;
}
